function GetLocalProfiles()
	local ret = {};
	for p = 0,PROFILEMAN:GetNumLocalProfiles()-1 do
		local profile = PROFILEMAN:GetLocalProfileFromIndex(p);
		local item = Def.ActorFrame{
			CommonNormal()..{
				Text=profile:GetDisplayName():upper();
				InitCommand=cmd(xy,-154,6;zoom,0.6;align,0,0);
			};
			Miso()..{
				InitCommand=cmd(xy,-154,26;zoom,0.55;align,0,0);
				OnCommand=function(self)
					local text = profile:GetNumTotalSongsPlayed()
					local width = string.len(commify(text,","))
					self:settext(("Total Songs Played: "..commify(text,",")):upper()):AddAttribute(20,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,26+18;zoom,0.55;align,0,0);
				OnCommand=function(self)
					local text = profile:GetTotalCaloriesBurned()
					local width = string.len(commify(text,","))
					self:settext(("Burned Calories: "..commify(string.format("%0.f",text),",")):upper()):AddAttribute(17,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,26+18*2;zoom,0.55;align,0,0);
				OnCommand=function(self)
					local text = profile:GetTotalGameplaySeconds()
					local width = string.len(SecondsToHHMMSS(text))
					self:settext(("Total Gameplay: "..SecondsToHHMMSS(text)):upper()):AddAttribute(16,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,12+18+58;zoom,0.55;align,0,0);
				OnCommand=function(self)
					local text = profile:GetTotalTapsAndHolds() - profile:GetTotalHolds()
					local width = string.len(commify(text,","))
					self:settext(("Total Taps: "..commify(text,",")):upper()):AddAttribute(12,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,12+18*2+58;zoom,0.55;align,0,0);
				OnCommand=function(self)
					local text = profile:GetTotalHolds()
					local width = string.len(commify(text,","))
					self:settext(("Total Holds: "..commify(text,",")):upper()):AddAttribute(13,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,12+18*3+58;zoom,0.55;align,0,0);
				OnCommand=function(self)
					local text = profile:GetTotalJumps()
					local width = string.len(commify(text,","))
					self:settext(("Total Jumps: "..commify(text,",")):upper()):AddAttribute(13,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,12+18*4+58;zoom,0.55;align,0,0);
				OnCommand=function(self)
					local text = profile:GetTotalHands()
					local width = string.len(commify(text,","))
					self:settext(("Total Hands: "..commify(text,",")):upper()):AddAttribute(13,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,12+18*5+58;zoom,0.55;align,0,0);
				OnCommand=function(self)
					local text = profile:GetTotalMines()
					local width = string.len(commify(text,","))
					self:settext(("Total Mines: "..commify(text,",")):upper()):AddAttribute(13,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,12+18*6+58;zoom,0.55;align,0,0);
				OnCommand=function(self)
					local text = profile:GetTotalRolls()
					local width = string.len(commify(text,","))
					self:settext(("Total Rolls: "..commify(text,",")):upper()):AddAttribute(13,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,16+18+58+112;zoom,0.55;align,0,0);
				OnCommand=function(self)
					local text = profile:GetNumToasties()
					local width = string.len(commify(text,","))
					self:settext(("Total Toasties: "..commify(text,",")):upper()):AddAttribute(16,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,16+18*2+58+112;zoom,0.55;align,0,0;maxwidth,560);
				OnCommand=function(self)
					local text = profile:GetLastPlayedSong()
					if text == nil then text = "---" else text = text:GetDisplayFullTitle() end
					local width = string.len(text)
					self:settext(("Last Song: "..text):upper()):AddAttribute(11,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
			Miso()..{
				InitCommand=cmd(xy,-154,16+18*3+58+112;zoom,0.55;align,0,0;maxwidth,560);
				OnCommand=function(self)
					local text = profile:GetLastPlayedSong()
					if text == nil then text = "---" else text = text:GetGroupName() end
					local width = string.len(text)
					self:settext(("Last Group: "..text):upper()):AddAttribute(12,{Length = width; Diffuse = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)})
				end;
			};
		};
		table.insert( ret, item );
	end;
	return ret;
end;

function LoadCard()
	local t = Def.ActorFrame {
		-- Background
		Def.Quad{InitCommand=cmd(diffuse,Black();setsize,324,300;valign,0);};
		-- Profile Name
		Def.Quad{InitCommand=cmd(y,4;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2);setsize,316,20;valign,0);};
		-- Top
		Def.Quad{InitCommand=cmd(y,4+20;diffuse,color(LoadFile("ThemeColor.cfg","Settings"));setsize,316,58;valign,0);};
		-- Middle
		Def.Quad{InitCommand=cmd(y,8+20+58;diffuse,color(LoadFile("ThemeColor.cfg","Settings"));setsize,316,112;valign,0);};
		-- Bottom
		Def.Quad{InitCommand=cmd(y,12+20+58+112;diffuse,color(LoadFile("ThemeColor.cfg","Settings"));setsize,316,94;valign,0);};
	};
	return t
end

function LoadPlayerStuff(Player)
	local ret = {};
	local pn = (Player == PLAYER_1) and 1 or 2;

	local t = Def.ActorFrame {
		Name = 'JoinFrame';
		LoadCard(Color('White'));
		LoadFont("Common Normal") .. {
			Text=("Press &START; to join"):upper();
			InitCommand=cmd(y,136;valign,0;zoom,0.8);
			OnCommand=cmd(diffuseshift;effectcolor1,Color('White');effectcolor2,color("0.5,0.5,0.5"));
		};
	};
	table.insert( ret, t );
	
	t = Def.ActorFrame {
		Name = 'BigFrame';
		LoadCard(PlayerColor(Player));
	};
	table.insert( ret, t );

	t = Def.ActorFrame {
		Name = 'SmallFrame';

		InitCommand=cmd(y,-2);
		Def.Quad {
			InitCommand=cmd(zoomto,200-10,40+2);
			OnCommand=cmd(diffuse,Color('Black'));
		};
		Def.Quad {
			InitCommand=cmd(zoomto,200-10,40);
			OnCommand=cmd(diffuse,PlayerColor(Player);fadeleft,0.25;faderight,0.25;glow,color("1,1,1,0.25"));
		};
		Def.Quad {
			InitCommand=cmd(zoomto,200-10,40;y,-40/2+20);
			OnCommand=cmd(diffuse,Color("Black");fadebottom,1;diffusealpha,0.35);
		};
		Def.Quad {
			InitCommand=cmd(zoomto,200-10,1;y,-40/2+1);
			OnCommand=cmd(diffuse,PlayerColor(Player);glow,color("1,1,1,0.25"));
		};	
	};
	table.insert( ret, t );

	t = Def.ActorScroller{
		Name = 'ProfileScroller';
		NumItemsToDraw=1;
		OnCommand=cmd(y,1;SetSecondsPerItem,0.01);
		TransformFunction=function(self, offset, itemIndex, numItems)
			local focus = scale(math.abs(offset),0,2,1,0);
			self:visible(false);
			self:y(math.floor( offset*10 ));

		end;
		children = GetLocalProfiles();
	};
	table.insert( ret, t );
	
	t = Def.ActorFrame {
		Name = "EffectFrame";
	};
	table.insert( ret, t );

	t = LoadFont("Common Normal") .. {
		Name = 'SelectedProfileText';
		InitCommand=cmd(y,160;shadowlength,1;);
	};
	table.insert( ret, t );

	return ret;
end;

function UpdateInternal3(self, Player)
	local pn = (Player == PLAYER_1) and 1 or 2;
	local frame = self:GetChild(string.format("P%uFrame", pn));
	local scroller = frame:GetChild('ProfileScroller');
	local seltext = frame:GetChild('SelectedProfileText');
	local joinframe = frame:GetChild('JoinFrame');
	local smallframe = frame:GetChild('SmallFrame');
	local bigframe = frame:GetChild('BigFrame');

	if GAMESTATE:IsHumanPlayer(Player) then
		frame:visible(true);
		if MEMCARDMAN:GetCardState(Player) == 'MemoryCardState_none' then
			--using profile if any
			joinframe:visible(false);
			smallframe:visible(false);
			bigframe:visible(true);
			seltext:visible(false);
			scroller:visible(true);
			local ind = SCREENMAN:GetTopScreen():GetProfileIndex(Player);
			if ind > 0 then
				scroller:SetDestinationItem(ind-1);
				seltext:settext(PROFILEMAN:GetLocalProfileFromIndex(ind-1):GetDisplayName());
			else
				if SCREENMAN:GetTopScreen():SetProfileIndex(Player, 1) then
					scroller:SetDestinationItem(0);
					self:queuecommand('UpdateInternal2');
				else
					joinframe:visible(true);
					smallframe:visible(false);
					bigframe:visible(false);
					scroller:visible(false);
					seltext:settext('No profile');
				end;
			end;
		else
			--using card
			smallframe:visible(false);
			scroller:visible(false);
			seltext:settext('CARD');
			SCREENMAN:GetTopScreen():SetProfileIndex(Player, 0);
		end;
	else
		joinframe:visible(true);
		scroller:visible(false);
		seltext:visible(false);
		smallframe:visible(false);
		bigframe:visible(false);
	end;
end;

local t = Def.ActorFrame {
	StorageDevicesChangedMessageCommand=function(self, params)
		self:queuecommand('UpdateInternal2');
	end;
	CodeMessageCommand = function(self, params)
		if params.Name == 'Start' or params.Name == 'Center' then
			MESSAGEMAN:Broadcast("StartButton");
			if not GAMESTATE:IsHumanPlayer(params.PlayerNumber) then
				SCREENMAN:GetTopScreen():SetProfileIndex(params.PlayerNumber, -1);
			else
				SCREENMAN:GetTopScreen():Finish();
			end;
		end;
		if params.Name == 'Up' or params.Name == 'Up2' or params.Name == 'DownLeft' then
			if GAMESTATE:IsHumanPlayer(params.PlayerNumber) then
				local ind = SCREENMAN:GetTopScreen():GetProfileIndex(params.PlayerNumber);
				if ind > 1 then
					if SCREENMAN:GetTopScreen():SetProfileIndex(params.PlayerNumber, ind - 1 ) then
						MESSAGEMAN:Broadcast("DirectionButton");
						self:queuecommand('UpdateInternal2');
					end;
				end;
			end;
		end;
		if params.Name == 'Down' or params.Name == 'Down2' or params.Name == 'DownRight' then
			if GAMESTATE:IsHumanPlayer(params.PlayerNumber) then
				local ind = SCREENMAN:GetTopScreen():GetProfileIndex(params.PlayerNumber);
				if ind > 0 then
					if SCREENMAN:GetTopScreen():SetProfileIndex(params.PlayerNumber, ind + 1 ) then
						MESSAGEMAN:Broadcast("DirectionButton");
						self:queuecommand('UpdateInternal2');
					end;
				end;
			end;
		end;
		if params.Name == 'Back' then
			if GAMESTATE:GetNumPlayersEnabled()==0 then
				SCREENMAN:GetTopScreen():Cancel();
			else
				MESSAGEMAN:Broadcast("BackButton");
				SCREENMAN:GetTopScreen():SetProfileIndex(params.PlayerNumber, -2);
			end;
		end;
	end;
	PlayerJoinedMessageCommand=function(self, params)
		self:queuecommand('UpdateInternal2');
	end;
	PlayerUnjoinedMessageCommand=function(self, params)
		self:queuecommand('UpdateInternal2');
	end;
	OnCommand=function(self, params)
		self:queuecommand('UpdateInternal2');
	end;
	UpdateInternal2Command=function(self)
		UpdateInternal3(self, PLAYER_1);
		UpdateInternal3(self, PLAYER_2);
	end;
	children = {
		Def.ActorFrame{
			Name="P1Frame";
			InitCommand=cmd(x,CenterX()-205;y,Top()+118);
			PlayerJoinedMessageCommand=function(self,param) if param.Player == PLAYER_1 then (cmd(;zoom,1.15;bounceend,0.175;zoom,1.0;))(self); end; end;
			children = LoadPlayerStuff(PLAYER_1);
		};
		Def.ActorFrame{
			Name="P2Frame";
			InitCommand=cmd(x,CenterX()+205;y,Top()+118);
			PlayerJoinedMessageCommand=function(self,param) if param.Player == PLAYER_2 then (cmd(zoom,1.15;bounceend,0.175;zoom,1.0;))(self); end; end;
			children = LoadPlayerStuff(PLAYER_2);
		};
		LoadActor(THEME:GetPathS("Common","Start"))..{StartButtonMessageCommand=cmd(play); BackButtonMessageCommand=cmd(play); DirectionButtonMessageCommand=cmd(play);}
	};
};

return t;